//priority: 1000

// Constants
const posEffects = [
  //[effect, time, amplifier]
  ['minecraft:invisibility', 5, 0],
  ['minecraft:absorption', 5, 0],
  //['minecraft:instant_health', 1, 1],
  ['minecraft:regeneration', 10, 0],
  ['minecraft:resistance', 10, 1],
  ['minecraft:speed', 10, 0],
  ['minecraft:strength', 10, 1]
]

const negEffects = [
  ['minecraft:blindness', 5, 0],
  ['minecraft:hunger', 5, 0],
  ['minecraft:levitation', 5, 0],
  ['minecraft:mining_fatigue', 10, 0],
  ['minecraft:nausea', 10, 0],
  ['minecraft:poison', 10, 0],
  ['minecraft:slowness', 10, 0],
  ['minecraft:weakness', 10, 0],
  ['minecraft:slowness', 5, 1],
  ['minecraft:weakness', 5, 1]
]

const equipment = [
  ['HEAD', 'helmet'],
  ['CHEST', 'chestplate'],
  ['LEGS', 'leggings'],
  ['FEET', 'boots']
]

const flowers = [
  ["minecraft:cornflower", 'Cornflower'],
  ["minecraft:lily_of_the_valley", 'Lily of the Valley'],
  ["minecraft:pink_tulip", 'Pink Tulip'],
  ["minecraft:white_tulip", 'White Tulip'],
  ["minecraft:red_tulip", 'Red Tulip'],
  ["minecraft:orange_tulip", 'Orange Tulip'],
  ["minecraft:azure_bluet", 'Azure Bluet'],
  ["minecraft:allium", 'Allium'],
  ["minecraft:blue_orchid", 'Blue Orchid'],
  ["minecraft:poppy", 'Poppy'],
  ["minecraft:dandelion", 'Dandelion']]

const eyes = [
  'endrem:black_eye',
  'endrem:cold_eye',
  'endrem:rogue_eye',
  'endrem:old_eye',
  'endrem:nether_eye',
  'endrem:lost_eye',
  'endrem:cursed_eye',
  'endrem:corrupted_eye',
  'endrem:evil_eye',
  'endrem:guardian_eye',
  'endrem:cryptic_eye',
  'endrem:exotic_eye',
  'endrem:undead_eye',
  'endrem:witch_eye',
  'endrem:wither_eye',
  'endrem:magical_eye']

const coral = ['tube','brain','bubble','fire','horn']
const variation = ['', '_fan', '_block']

const sec = 20

// Functions
function giveVanillaGear(event, material){
  equipment.forEach(slot => {
    //console.log(`${slot[0]} : giving minecraft:${material}_${slot[1]}`)
    event.entity.setEquipment(slot[0], `minecraft:${material}_${slot[1]}`)
  })
}

function difficultyMulti(){
  let difficulty = Utils.level.getDifficulty()
  if (difficulty == "EASY") return 0.75
  if (difficulty == "NORMAL") return 1
  if (difficulty == "HARD") return 1.5
}

function title(username, text, color, bold, italic) {
    Utils.server.runCommandSilent(`title ${username} title ${JSON.stringify({
        text: text,
        bold: bold ?? true,
        italic: italic ?? false, 
        color: color ?? 'red'
    })}`)
}

function subtitle(username, text, color, bold, italic) {
    Utils.server.runCommandSilent(`title ${username} subtitle ${JSON.stringify({
        text: text,
        bold: bold ?? false,
        italic: italic ?? true, 
        color: color ?? 'yellow'
    })}`)
}

function actionbar(username, text, color, bold, italic) {
    Utils.server.runCommandSilent(`title ${username} actionbar ${JSON.stringify({
        text: text,
        bold: bold ?? false,
        italic: italic ?? false, 
        color: color ?? 'yellow'
    })}`)
}

function delay(delay, command){
    Utils.server.scheduleInTicks(delay, (_) => command)

}

function getRandomInt(min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min) + min);
}

function customName(entity, name, chance) {
  if(getRandomInt(1, 100)<chance){
    let nbt = entity.fullNBT
    nbt.CustomName = `{"text":"${name}"}`
    nbt.CustomNameVisible = true
    entity.fullNBT = nbt
  }
}

function dialog(event, dialoglist, delay){
  let initdelay = delay
  dialoglist.forEach(text => {
    delay = delay+initdelay
    Utils.server.scheduleInTicks(delay, (_) => event.player.tell(text))
  })
}

function capFirst(string) {
  return string[0].toUpperCase() + string.slice(1);
}

function skyRaid(event) {
  const {x, y, z} = event.entity
  let pData = event.entity.persistentData
  pData.x = x
  pData.y = y
  pData.z = z
  pData.alive = 1


  
}

function skyRaidTick(event) {
  // Check if still Alive, else Kill loop
  if (!event) {
    //console.log('Entity Not there anymore')
    return
  }
  if (!event.entity.living){
    return
  }

  let pData = event.entity.persistentData
  if (event.entity.y < pData.y-32){
    //console.log('entity Falling!)')
    event.entity.x = pData.x
    event.entity.y = pData.y+2
    event.entity.z = pData.z
    let potion = event.entity.potionEffects
    potion.add('minecraft:slow_falling', 20, 0, false, false)

  }
  // Loop skyRaidTick
  if (pData.alive == 1) event.server.scheduleInTicks(20,_ =>{
    skyRaidTick(event)
    //console.log(`ticking ${event.entity.type}`)
  })

}

function died(event) {
  let pData = event.entity.persistentData
  pData.alive = 0
}

/*
function bossbar(entity, name, color, distance) {
  const {id, health, maxHealth, x, y, z} = entity
  color = color ?? 'red'
  distance = distance ?? 20
  let commands  = [
    `bossbar add ${id} "${name}"`,
    `bossbar set minecraft:${id} color ${color}`,
    `bossbar set minecraft:${id} max ${maxHealth}`,
    `bossbar set minecraft:${id} value ${health}`,
    `bossbar set minecraft:${id} players @p[x=${x}, y=${y}, z=${z}, distance=..${distance}]`
  ]
  commands.forEach(command => {
    Utils.server.runCommandSilent(command);
  })
}

function bossbarHealth(entity) {
  const {id, health, x, y, z} = entity
  let distance = 32
  console.log(id)
  Utils.server.runCommandSilent(`bossbar set minecraft:${id} value ${Math.round(health)}`)
  Utils.server.runCommandSilent(`bossbar set minecraft:${id} players @p[x=${x}, y=${y}, z=${z}, distance=..${distance}]`)
}

function loopHealth(entity){
  if (!entity.living) {
    console.log('Boss Dead')
    Utils.server.runCommandSilent(`bossbar remove minecraft:${entity.id}`)
    return //it's dead or gone, stop trying to update
  }
  
  //Add your tick events here
  const {id, x, y, z} = entity 
  //`bossbar set minecraft:${id} players @p[x=${x}, y=${y}, z=${z}, distance=..128]`
  bossbarHealth(entity)
  // Loop updateEntity every 20 Ticks (1 Sec)
  Utils.server.scheduleInTicks(2,_ => {
      loopHealth(entity)        
})
}*/

function objectKeys(arg) {
  console.log(Object.keys(arg))
}

function adjHealth(event, item) {
  const {player, server} = event
  let stageName = item.split(':')[1]
  if (!player.stages.has(stageName)) {
    player.stages.add(stageName)
    player.persistentData.eyecounter += 1
    player.persistentData.hearts = 20+(player.persistentData.eyecounter*2)
    /*
    
    let curHealth = player.getMaxHealth()
    player.persistentData.hearts = curHealth+2-modifierAmount
    player.tell(`curHealth: ${curHealth}  | mod: ${modifierAmount}   | hearts: ${player.persistentData.hearts}`)
    */
    player.setMaxHealth(player.persistentData.hearts)
    player.setAttributeBaseValue('minecraft:generic.max_health', player.persistentData.hearts)
    player.tell(`You have gained an additional Heart!`)
    
  }
}

function blockBreak(event, range) {
    const blacklist = [
      'minecraft:bedrock',
      'spirit:soul_pedestal',
      'spirit:pedestal',
      'indrev:wither_proof_obsidian',
      'summoningrituals:indestructible_altar'
  ]
  const {entity, level} =  event
  const {x, y, z} = entity

  let posRange = range
  let negRange = range-range-range

  for (let ix = negRange; ix < posRange; ix++) {
      for (let iz = negRange; iz < posRange; iz++) {
          for (let iy = 0; iy < posRange; iy++) {
              let block = event.level.getBlock([x+ix, y+iy, z+iz])

              if (!blacklist.includes(block.id)){
                  block.popItem(block.id)
                  block.set('air')}

          }
      }
  }
}